<?php

namespace App\Http\Controllers\Admin;

use DataTables;
use App\Models\Supplier;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;

class OrderController extends Controller
{
    public function __construct(){
        $this->middleware(['auth'])->except('store');
    }
    public function index(){
        return view('purchase_order.index');
    }

    public function allOrders(Request $request){
        if ($request->ajax()) {
            $records=DB::table('view_products_orders')
                        ->groupBy('variation_id')
                        // ->groupBy(['created_at','prod_size','prod_gender','prod_type','prod_color'])//DATE(created_at)
                        ->orderBy('pr_id','DESC')
                        ->orderBy('prod_size','ASC')
                        
                        ->where('status','0')
                        ->get(['variation_id',DB::raw('sum(approve_qtn) as approve_qtn'),'pr_id','id','created_at','is_urgent','id','prod_gender','prod_type','prod_color','prod_size'
                            ]);
            return Datatables::of($records)
                ->addIndexColumn()
                ->addColumn('product_img',function($data){
                    if($data->prod_type<10){
                        $prod_type='0'.$data->prod_type;
                    }else{
                        $prod_type=$data->prod_type;
                    }
                    $g=$data->prod_gender.$prod_type.$data->prod_color;
                    
                    $type_image=DB::table('type_images')->where('code',$g)->get(['image']);
                    if(isset($type_image[0]->image)){
                        $url=$type_image[0]->image;
                        $img=' <img src="'.$type_image[0]->image.'" class="rounded" alt="Cinque Terre" width="200" height="200">';
                        $product_detail='
                            <div class="row">
                                <div class="col-md-6">
                                    <a class="single_image" href="'.$url.'" target="_blank" data-featherlight="image">
                                        '.$img.'
                                    </a><br>
                                    Variation ID : <strong>'.$data->variation_id.'</strong>
                                </div>
                            </div>
                        ';
                        return $product_detail;
                        
                    }else{
                        $product_detail='
                            <div class="row">
                                <div class="col-md-6">
                                    Variation ID : <strong>'.$data->variation_id.'</strong>
                                </div>
                            </div>
                        ';
                        return $product_detail;
                    }
                })
                ->addColumn('product_name',function ($data){
                    $get=DB::table('product_info')->where('variation_id',$data->variation_id)->get();
                    if($data->is_urgent=='1'){
                        $status='<span class="badge badge-danger">Urgent</span>';
                    }else{
                        $status='';
                    }
                    if(isset($get[0]->product_name)){
                        $product_detail='
                            <div class="row">
                                <div class="col-md-6">
                                '.$get[0]->product_name.'<br>'.$status.'<br>
                                </div>
                            </div>
                        ';
                    }else{
                        $product_detail='
                        <div class="row">
                            <div class="col-md-6">
                            '.$data->variation_id.'
                            </div>
                        </div>
                    ';
                    }
                    
                    

                    return $product_detail;
                })
                ->addColumn('size',function ($data){
                    $s=DB::table('product_size')->where('id',$data->prod_size)->get(['size']);
                    return $s[0]->size;
                })
                ->addColumn('approve_qtn',function ($data){
                    $get=DB::table('product_info')->where('variation_id',$data->variation_id)->get();
                    if($data->approve_qtn>$get[0]->Quantity){
                        $checked="checked";
                        $warehouse=$get[0]->Quantity;
                        $supplier_val=(int)$data->approve_qtn - (int)$get[0]->Quantity;

                        $product_detail='
                                <span class="text-success">Order QTY : <strong id="approve_'.$data->id.'">'.$data->approve_qtn.'</strong></span><br>
                                <div class="form-check">
                                    <div class="checkbox">
                                        <label for="checkbox1" class="form-check-label ">
                                            <input type="checkbox" id="checkbox_'.$data->id.'" name="warehouse_checked_'.$data->id.'" value="'.$data->id.'" onchange="checked_approve('.$data->id.')"  class="form-check-input approve_check" '.$checked.'>Warehouse Assign
                                        </label>
                                    </div>
                                </div><br>
                                <div id="show_'.$data->id.'">
                                    <span class="text-danger">Quantity : <strong>'.$data->approve_qtn.' - '.$get[0]->Quantity.'</strong></span><br>
                                    <span class="text-info">Warehouse Supplier: <strong id="war_'.$data->id.'">'.$warehouse.'</strong></span><br>
                                    <span class="text-primary">Supplier : <strong id="sup_'.$data->id.'">'.$supplier_val.'</strong></span>
                                </div>';
                                
                        return $product_detail;
                    }
                    
                    return '<span class="text-success">Order QTY : <strong>'.$data->approve_qtn.'</strong></span>';
                })
                ->addColumn('quantity',function ($data){
                    $get=DB::table('product_info')->where('variation_id',$data->variation_id)->get();
                    return $get[0]->Quantity;
                })
                ->addColumn('created_at',function ($data){
                    $created='<div class="form-check">
                                <div class="checkbox">
                                    <input type="checkbox" id="id_check_'.$data->id.'" name="id_check[]" value="'.$data->id.'" class="form-check-input id_check"><br>
                                    <span>'.date('d-m-Y', strtotime($data->created_at)).'</span>
                                </div>
                            </div>
                        ';
                    return $created;
                })
                ->addColumn('options',function ($data){
                    $get=DB::table('product_info')->where('variation_id',$data->variation_id)->get();
                    if($data->approve_qtn>$get[0]->Quantity){
                        $warehouse=$get[0]->Quantity;
                        $supplier_val=(int)$data->approve_qtn - (int)$get[0]->Quantity;
                        $hidden='<input type="hidden" name="warehouse_qtn[]" id="warehouse_qtn_'.$data->id.'" value="'.$warehouse.'"/>
                        <input type="hidden" name="supplier_qtn[]" id="supplier_qtn_'.$data->id.'" value="'.$supplier_val.'"/>';

                    }else{
                        $hidden='<input type="hidden" name="warehouse_qtn[]" id="warehouse_qtn_'.$data->id.'" value="0"/>
                        <input type="hidden" name="supplier_qtn[]" id="supplier_qtn_'.$data->id.'" value="'.$data->approve_qtn.'"/>';
                    }
                    $hidden.='<input type="hidden" id="pr_id_'.$data->id.'" name="pr_id[]"  value="'.$data->pr_id.'"/>
                        <input type="hidden" name="id[]" value="'.$data->id.'"/>
                        <input type="hidden" id="variation_id_'.$data->id.'" name="variation_id[]" value="'.$data->variation_id.'"/>
                        <input type="hidden" id="quantity_'.$data->id.'" name="quantity[]" value="'.$get[0]->Quantity.'"/>

                        ';

                    $supplier=Supplier::latest()->get(['supplier_name','id']);

                    $options='<select name="options[]" id="options_'.$data->id.'" class="form-control options select2">
                        <option value="">Please select</option>';
                    foreach ($supplier as $key => $value) {
                        $options.='<option value="'.$value['id'].'" >'.$value['supplier_name'].'</option>';
                    }
                    $options.='</select><span id="error_'.$data->id.'" class="text-danger text-sm" style="display:none">Please Select</span>'.$hidden.'<br>'.$data->id;
                    return $options;
                })
                ->rawColumns(['pr_id','product_img','product_name','size','approve_qtn','quantity','created_at','options'])
                ->make(true);
        }
    }

    public function store(Request $request){
        // dd($request->json()->all());
        $json = $request->json()->all();
        $count=DB::table('view_products_orders')->orderBy('pr_id', 'desc')->first();
        // dd($count);
        if($count ==null){
            $pr_id=1;
        }else{
            $pr_id=($count->pr_id)+1;
        }
        
        
        foreach ($json as $key => $value) {
            $insert=[
                'variation_id' => '4'.$value['variation_id'],
                'given_qtn'=>$value['given_qnt'],
                'approve_qtn' => $value['assign_qnt'],
                'is_urgent'=>$value['urgency'],
                'created_by'=>$value['created_by'],
                'pr_id' => $pr_id,
                'created_at' => date('Y-m-d H:i:s'),
                'prod_gender' => $value['prod_gender'],
                'prod_type' => $value['prod_type'],
                'prod_color' => $value['prod_color'],
                'prod_size' => $value['prod_size'],
            ];
            

            $insert_data=DB::table('view_products_orders')->insert($insert);
        }

        return response()->json(['success' => "Product added successfully"], 200);
    }

    public function assign_quantity(Request $request){
        $input=$request->all();
        $data=array();
        foreach($input['array'] as $key => $value){
            $get=DB::table('view_products_orders')->where('id',$value['id'])->get(['prod_gender','approve_qtn','prod_type','prod_color','prod_size']);
            if($get[0]->prod_type<10){
                $prod_type='0'.$get[0]->prod_type;
            }else{
                $prod_type=$get[0]->prod_type;
            }

            if($value['checkbox']==$value['id']){
                if($value['warehouse_qtn'] !='0'){
                    $insert=[
                        'variation_id' => $value['variation_id'],
                        'main_type' => $get[0]->prod_gender.$prod_type.$get[0]->prod_color,
                        'prod_size' => $get[0]->prod_size,
                        'in_stock' =>  $value['quantity'],
                        'supplier_id' => 1,
                        'assign_date' => date('Y-m-d'),
                        'order_qty_given' => $get[0]->approve_qtn,
                        'receive_qty' => $value['warehouse_qtn'],
                        'pr_id' => $value['pr_id']
                    ];
                    $response=DB::table('assign_quantity')->insert($insert);
                    $data[]=$insert;
                }
                $insert1=[
                    'variation_id' => $value['variation_id'],
                    'main_type' => $get[0]->prod_gender.$prod_type.$get[0]->prod_color,
                    'prod_size' => $get[0]->prod_size,
                    'in_stock' =>  $value['quantity'],
                    'supplier_id' => $value['options'],
                    'assign_date' => date('Y-m-d'),
                    'order_qty_given' => $get[0]->approve_qtn,
                    'receive_qty' => $value['supplier_qtn'],
                    'pr_id' => $value['pr_id']
                ];
                $response=DB::table('assign_quantity')->insert($insert1);
                $data[]=$insert1;
            }else{
                $insert=[
                    'variation_id' => $value['variation_id'],
                    'main_type' => $get[0]->prod_gender.$prod_type.$get[0]->prod_color,
                    'prod_size' => $get[0]->prod_size,
                    'in_stock' =>  $value['quantity'],
                    'supplier_id' => $value['options'],
                    'assign_date' => date('Y-m-d'),
                    'order_qty_given' => $get[0]->approve_qtn,
                    'receive_qty' => $value['supplier_qtn'],
                    'pr_id' => $value['pr_id']
                ];
                $data[]=$insert;
                $response=DB::table('assign_quantity')->insert($insert);
            }

            DB::table('view_products_orders')
              ->where('id', $value['id'])
              ->update(['status' => 1]);
        }
        
        return $response;
    }

    


}
